/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.command;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import cz.insophy.inplan.command.Command;
import cz.insophy.inplan.mrp.CustomerRequest;
import cz.insophy.inplan.planning.algorithms.RebuildPlannerUtils;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.ProductionTreeAlgorithms;
import cz.insophy.inplan.superplan.Superplan;
import cz.insophy.inplan.util.Localizer;
import cz.insophy.inplan.util.problems.Problem;
import java.util.ArrayList;
import java.util.List;

public class UnplanGorsCommand
implements Command {
    private static final long serialVersionUID = 1L;
    private List<String> gorIds;
    private List<String> crIds;

    public UnplanGorsCommand(List<String> gorIds, List<String> crIds) {
        this.gorIds = gorIds;
        this.crIds = crIds;
    }

    @Override
    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        int MAX_GOR_IDS = 5;
        if (this.gorIds.size() > 5) {
            Joiner.on(", ").appendTo(sb, (Iterable<? extends Object>)this.gorIds.subList(0, 5));
            sb.append(", ...");
        } else {
            Joiner.on(", ").appendTo(sb, (Iterable<? extends Object>)this.gorIds);
        }
        if (this.crIds.size() > 0) {
            sb.append("; ");
            sb.append(this.crIds.size());
            sb.append(" ZO: ");
            if (this.crIds.size() > 5) {
                Joiner.on(", ").appendTo(sb, (Iterable<? extends Object>)this.crIds.subList(0, 5));
                sb.append(", ...");
            } else {
                Joiner.on(", ").appendTo(sb, (Iterable<? extends Object>)this.crIds);
            }
        }
        return Localizer.getString("command.unplan_gors.desc", this.gorIds.size(), sb.toString());
    }

    @Override
    public List<Problem> execute(Superplan superplan) {
        Preconditions.checkNotNull(superplan);
        ArrayList<Problem> problems = Lists.newArrayList();
        int unplannedGors = 0;
        for (String gorId : this.gorIds) {
            GeneralizedOrderRequest gor = superplan.getGor(gorId);
            if (gor != null) {
                ProductionTreeAlgorithms.removeRelatedActivities(gor);
                if (!gor.isFixed() && !gor.isActiongramLocked()) {
                    gor.cancelActiongram();
                }
                ++unplannedGors;
                continue;
            }
            problems.add(Problem.createProblem2("04050", gorId));
        }
        for (String crId : this.crIds) {
            CustomerRequest cr = superplan.getCustomerRequest(crId);
            if (cr != null) {
                superplan.removeCustomerRequest(cr);
                continue;
            }
            problems.add(Problem.createProblem2("04051", crId));
        }
        if (unplannedGors > 0) {
            RebuildPlannerUtils.fixAndRegister(superplan.getPlan());
        }
        return problems;
    }
}

